/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.visio.model.mapping;

import filenet.vw.api.VWException;
import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWString;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.base.XMLHelper;
import filenet.vw.toolkit.design.visio.model.Shape;
import filenet.vw.toolkit.design.visio.model.mapping.VWMappingItem;
import filenet.vw.toolkit.design.visio.model.mapping.VWMappingLists;
import filenet.vw.toolkit.design.visio.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class VWMappingFileWrapper {
    private static final String XML_PREAMBLE = "<?xml version='1.0' encoding='UTF-8'?>\n";
    private static final String INDENT_ONE = "\t";
    private static final String INDENT_TWO = "\t\t";
    private static final String INDENT_THREE = "\t\t\t";
    private static final String MAPPING_FILE_BASE_PATH = "filenet/vw/toolkit/design/visio/model/mapping/";
    private static final String DEFAULT_MAPPING_FILE_NAME = "visio_mapping";
    private VWDesignerCoreData m_designerCoreData = null;
    private String m_filePath = null;
    private Hashtable m_mappingTable = null;
    private Hashtable m_mappedShapesTable = null;
    private VWMappingLists m_mappingLists = null;

    public VWMappingFileWrapper(VWDesignerCoreData designerCoreData) {
        this.m_designerCoreData = designerCoreData;
    }

    public boolean isInitialized() {
        return this.m_mappingTable != null;
    }

    public void loadDefaultMappingFile() throws VWException {
        ClassLoader externalClassLoader = this.m_designerCoreData.getSessionInfo().getExternalClassLoader();
        String mappingFilePath = "filenet/vw/toolkit/design/visio/model/mapping/visio_mapping";
        InputStream inStream = this.getMappingResourceAsStream(externalClassLoader, mappingFilePath);
        this.loadShapeMappingFromStream(inStream);
        this.m_filePath = null;
    }

    public void loadShapeMappingFromFile(String filePath) throws VWException {
        try {
            if (filePath != null) {
                File mappingFile = new File(filePath);
                if (mappingFile != null && mappingFile.exists()) {
                    FileInputStream inStream = new FileInputStream(filePath);
                    this.loadShapeMappingFromStream(inStream);
                }
                this.m_filePath = filePath;
            }
        }
        catch (VWException ex) {
            throw ex;
        }
        catch (Exception ex) {
            VWException theException = new VWException("vw.toolkit.design.visio.model.mapping.FileReadError", "{0}", ex.getMessage());
            theException.setCause(ex);
            throw theException;
        }
    }

    public void resetMappedShapes() {
        this.m_mappedShapesTable = new Hashtable();
    }

    public void addShape(Shape shape) {
        if (shape != null && this.m_mappingTable != null) {
            VWMappingItem newMappingItem = null;
            String key = VWMappingItem.getCanonicalName(shape.getNameU(), shape.getText());
            if (!this.m_mappedShapesTable.containsKey(key)) {
                if (this.m_mappingTable.containsKey(key)) {
                    newMappingItem = (VWMappingItem)this.m_mappingTable.get(key);
                    if (newMappingItem.getVisioShape() == null) {
                        newMappingItem.setVisioShape(shape);
                    }
                } else {
                    VWMappingItem mappingItem;
                    newMappingItem = new VWMappingItem(shape);
                    if (this.m_mappingTable.containsKey(newMappingItem.getVisioShapeNameU()) && (mappingItem = (VWMappingItem)this.m_mappingTable.get(newMappingItem.getVisioShapeNameU())) != null && mappingItem.isMapped()) {
                        newMappingItem.setDesignerObjectName(mappingItem.getDesignerObjectName());
                    }
                    this.m_mappingTable.put(newMappingItem.getName(), newMappingItem);
                }
                this.m_mappedShapesTable.put(newMappingItem.getName(), newMappingItem);
            }
        }
    }

    public String lookUpShape(Shape shape) {
        if (shape != null && this.m_mappedShapesTable != null) {
            String key = VWMappingItem.getCanonicalName(shape.getNameU(), shape.getText());
            VWMappingItem mappingItem = (VWMappingItem)this.m_mappedShapesTable.get(key);
            return mappingItem.getDesignerObjectName();
        }
        return null;
    }

    public VWMappingLists getMappingLists() throws Exception {
        if (this.m_mappingLists == null) {
            this.m_mappingLists = new VWMappingLists();
        }
        return this.m_mappingLists;
    }

    public VWMappingItem[] getMappingItems() throws VWException {
        try {
            Object[] mappingItems = null;
            if (this.m_mappedShapesTable != null && !this.m_mappedShapesTable.isEmpty()) {
                mappingItems = new VWMappingItem[this.m_mappedShapesTable.size()];
                int nIndex = 0;
                Enumeration myEnum = this.m_mappedShapesTable.elements();
                while (myEnum.hasMoreElements()) {
                    mappingItems[nIndex++] = (VWMappingItem)myEnum.nextElement();
                }
                VWQubbleSort.sort(mappingItems);
            }
            return mappingItems;
        }
        catch (Exception ex) {
            VWException theException = new VWException("vw.toolkit.design.visio.model.mapping.ErrorRetrievingMappingItems", "{0}", ex.getMessage());
            theException.setCause(ex);
            throw theException;
        }
    }

    public String getFileName() {
        int nIndex;
        if (this.m_filePath != null && this.m_filePath.length() > 0 && (nIndex = this.m_filePath.lastIndexOf("\\")) != -1) {
            return this.m_filePath.substring(nIndex + 1, this.m_filePath.length());
        }
        return VWResource.s_defaultMapping;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveShapeMappingToFile(String filePath) throws VWException {
        if (this.m_mappingTable == null) return;
        FileOutputStream outStream = null;
        try {
            try {
                outStream = new FileOutputStream(filePath);
                StringBuffer buffer = new StringBuffer(XML_PREAMBLE);
                buffer.append("<Mappings>\n");
                Object[] keys = new String[this.m_mappingTable.size()];
                int nIndex = 0;
                Enumeration myEnum = this.m_mappingTable.keys();
                while (myEnum.hasMoreElements()) {
                    keys[nIndex++] = (String)myEnum.nextElement();
                }
                VWQubbleSort.sort(keys);
                for (nIndex = 0; nIndex < keys.length; ++nIndex) {
                    VWMappingItem mappingItem = (VWMappingItem)this.m_mappingTable.get(keys[nIndex]);
                    String visioShape = this.getSafeXMLString(mappingItem.getVisioShapeNameU());
                    String shapeText = this.getSafeXMLString(mappingItem.getVisioShapeText());
                    String fnObjectName = this.getSafeXMLString(mappingItem.getDesignerObjectName());
                    buffer.append("\t<Map>\n");
                    buffer.append("\t\t<Visio>\n");
                    buffer.append("\t\t\t<Name>" + visioShape + "</" + "Name" + ">\n");
                    if (shapeText != null && shapeText.length() > 0) {
                        buffer.append("\t\t\t<Text>" + shapeText + "</" + "Text" + ">\n");
                    }
                    buffer.append("\t\t</Visio>\n");
                    buffer.append("\t\t<Designer>\n");
                    buffer.append("\t\t\t<Name>" + fnObjectName + "</" + "Name" + ">\n");
                    buffer.append("\t\t</Designer>\n");
                    buffer.append("\t</Map>\n");
                    mappingItem.setIsModified(false);
                }
                buffer.append("</Mappings>");
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)outStream, "UTF8");
                out.write(buffer.toString());
                ((Writer)out).flush();
                this.m_filePath = filePath;
            }
            catch (Exception ex) {
                VWException theException = new VWException("vw.toolkit.design.visio.model.mapping.VWMappingFileWrapper.ErrorWritingToFile", "Exception writing XML to file: {0}.", ex.getLocalizedMessage());
                theException.setCause(ex);
                throw theException;
            }
            Object var11_12 = null;
            if (outStream == null) return;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (outStream == null) throw throwable;
            try {
                ((OutputStream)outStream).close();
                throw throwable;
            }
            catch (Exception ex1) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex1) {}
        ((OutputStream)outStream).close();
        return;
    }

    private InputStream getMappingResourceAsStream(ClassLoader classLoader, String filePath) {
        Locale locale = this.m_designerCoreData.getSessionInfo().getBrowserLocale();
        InputStream inStream = classLoader.getResourceAsStream(filePath + "_" + locale.getLanguage() + "_" + locale.getCountry() + ".xml");
        if (inStream == null) {
            inStream = classLoader.getResourceAsStream(filePath + "_" + locale.getLanguage() + ".xml");
        }
        if (inStream == null) {
            inStream = classLoader.getResourceAsStream(filePath + "_en_US.xml");
        }
        if (inStream == null) {
            VWDebug.logWarning("[WARNING] Could not find " + filePath + " mapping file! Locale = " + locale);
        }
        return inStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadShapeMappingFromStream(InputStream inStream) throws VWException {
        if (inStream == null) {
            throw new VWException("vw.toolkit.design.visio.model.mapping.NullInputStream", "The InputStream parameter is null.");
        }
        try {
            try {
                InputStreamReader isr = new InputStreamReader(inStream, "UTF8");
                BufferedReader bufferedReader = new BufferedReader(isr);
                InputSource inputSource = new InputSource(bufferedReader);
                this.parseMappingFile(inputSource);
            }
            catch (VWException ex) {
                throw ex;
            }
            catch (Exception ex) {
                VWException theException = new VWException("vw.toolkit.design.visio.model.mapping.ErrorReadingFile", "Exception reading mapping file, {0}.", ex.getLocalizedMessage());
                theException.setCause(ex);
                throw theException;
            }
            Object var6_8 = null;
            if (inStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (inStream == null) throw throwable;
            try {
                inStream.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex) {}
        inStream.close();
        return;
    }

    private void parseMappingFile(InputSource inputSource) throws VWException {
        try {
            VWXMLWrapper xmlWrapper = new VWXMLWrapper(inputSource, null);
            if (xmlWrapper != null) {
                Node documentNode = xmlWrapper.getRootNode();
                if (documentNode == null || "Mappings".compareTo(documentNode.getNodeName()) != 0) {
                    throw new VWException("vw.toolkit.design.visio.model.mapping.NoMappingTag", "''Mappings'' tag not found.");
                }
                this.m_mappingTable = new Hashtable();
                this.m_mappedShapesTable = new Hashtable();
                Node[] childNodes = VWXMLWrapper.getNodesNamed(documentNode, "Map");
                if (childNodes != null) {
                    for (int i = 0; i < childNodes.length; ++i) {
                        Node designerNode;
                        String visioShapeName = null;
                        String shapeText = null;
                        String designerObjectName = null;
                        Node visioNode = VWXMLWrapper.getNodeNamed(childNodes[i], "Visio");
                        if (visioNode != null) {
                            visioShapeName = VWXMLWrapper.getNodeValue(visioNode, "Name");
                            shapeText = VWXMLWrapper.getNodeValue(visioNode, "Text");
                        }
                        if ((designerNode = VWXMLWrapper.getNodeNamed(childNodes[i], "Designer")) != null) {
                            designerObjectName = VWXMLWrapper.getNodeValue(designerNode, "Name");
                            designerObjectName = this.getMappingLists().lookupItem(designerObjectName);
                        }
                        if (visioShapeName == null) continue;
                        VWMappingItem mappingItem = new VWMappingItem(visioShapeName, shapeText, designerObjectName);
                        this.m_mappingTable.put(mappingItem.getName(), mappingItem);
                    }
                }
            }
        }
        catch (SAXParseException saxEx) {
            VWString parsingError = new VWString("vw.toolkit.design.visio.model.mapping.parsingError", "** Parsing error");
            VWString line = new VWString("vw.toolkit.design.visio.model.mapping.line", "line");
            String errString = parsingError + ", " + line + " " + saxEx.getLineNumber() + ", uri " + saxEx.getSystemId() + "\n" + "   " + saxEx.getMessage();
            VWException theException = new VWException("vw.toolkit.design.visio.model.mapping.MappingReadParse", "Mapping file parsing error {0}.", errString);
            theException.setCause(saxEx);
            throw theException;
        }
        catch (VWException ex) {
            throw ex;
        }
        catch (Exception ex) {
            VWException theException = new VWException("vw.toolkit.design.visio.model.mapping.XMLReadError_2", "{0}", ex.getMessage());
            theException.setCause(ex);
            throw theException;
        }
    }

    private String getSafeXMLString(String tmpString) {
        tmpString = XMLHelper.toXMLString(tmpString);
        return tmpString.toString();
    }
}

